<?php
/**
 * WPML Integration Class
 *
 * @link       http://codeamp.com
 * @since      1.0.0
 * @package    Custom_Layouts
 */
namespace Custom_Layouts\Integrations;

/**
 * All WPML integration functionality
 */
class WPML {
	static $has_checked_wpml = false;
	static $has_wpml = false;

	public static function init() {
		add_filter( 'custom-layouts/layout/id', 'Custom_Layouts\\Integrations\\WPML::convert_layout_id', 10 );
		add_filter( 'custom-layouts/template/id', 'Custom_Layouts\\Integrations\\WPML::convert_template_id', 10 );

		add_filter( 'custom-layouts/admin/layout_info', 'Custom_Layouts\\Integrations\\WPML::api_info', 10 );
		add_filter( 'custom-layouts/admin/template_info', 'Custom_Layouts\\Integrations\\WPML::api_info', 10 );
		add_action( 'custom-layouts/settings/get_templates_options', 'Custom_Layouts\\Integrations\\WPML::options_switch_language', 10 );
		add_action( 'custom-layouts/settings/get_layouts_options', 'Custom_Layouts\\Integrations\\WPML::options_switch_language', 10 );

		add_filter( 'custom-layouts/settings/layouts', 'Custom_Layouts\\Integrations\\WPML::restrict_query_args', 10 );
		add_filter( 'custom-layouts/settings/templates', 'Custom_Layouts\\Integrations\\WPML::restrict_query_args', 10 );

		add_filter( 'custom-layouts/settings/set', 'Custom_Layouts\\Integrations\\WPML::update_setting', 10, 3 );
	}

	/* Change the lang according top the passed param */
	public static function update_setting( $settings, $post_id, $section ) {
		if ( ! self::has_wpml() ) {
			return $settings;
		}
		if ( $section !== 'layout' ) {
			return $settings;
		}

		if ( isset( $settings['template_id'] ) ) {
			// we want to try to convert the template ID to the correct translation value
			$settings['template_id'] = self::convert_template_id( $settings['template_id'] );
		}
		return $settings;
		
	}
	/* Change the lang according top the passed param */
	public static function options_switch_language( $language ) {
		if ( ! self::has_wpml() || $language == '' ) {
			return;
		}
		do_action( 'wpml_switch_language', $language );
	}
	/* Add WPML data layout info request */
	public static function api_info( $data ) {
		if ( ! self::has_wpml() ) {
			return $data;
		}
		$data[ 'hasWPML' ] = self::has_wpml();
		$data[ 'language' ] = self::get_current_language();
		return $data;
	}
	/**
	 * Disable suppress_filters so `wpml_switch_lang` will actually have an effect
	 *
	 * @since    1.4.2
	 */
	public static function restrict_query_args( $args ) {
		if ( ! self::has_wpml() ) {
			return $args;
		}
		$args['suppress_filters'] = false;
		return $args;
	}
	/**
	 * Covert the layout ID the the current language ID (if the translation exists)
	 *
	 * @since    1.4.2
	 */
	public static function convert_template_id( $post_id ) {
		if ( ! self::has_wpml() ) {
			return $post_id;
		}
		return self::convert_post_id( $post_id, 'cl-template' );
	}
	/**
	 * Covert the layout ID the the current language ID (if the translation exists)
	 *
	 * @since    1.4.2
	 */
	public static function convert_layout_id( $post_id ) {
		if ( ! self::has_wpml() ) {
			return $post_id;
		}
		return self::convert_post_id( $post_id, 'cl-layout' );
	}

	/**
	 * Covert the layout ID the the current language ID (if the translation exists)
	 *
	 * @since    1.4.2
	 */
	public static function convert_post_id( $post_id, $post_type ) {
		if ( ! self::has_wpml() ) {
			return $post_id;
		}
		$translated_id = $post_id;
		$language = self::get_current_language();
		if ( $language ) {
			$translated_id = self::object_id( $post_id, $post_type, true, $language );
		}
		return $translated_id;
	}

	/**
	 * Check if WPML is enabled or not
	 *
	 * @since    1.4.2
	 */
	public static function has_wpml() {
		
		if ( ! self::$has_checked_wpml ) {
			self::$has_checked_wpml = true;
	
			if ( ( has_filter( 'wpml_object_id' ) ) ) {
				self::$has_wpml = true;
			}
		}

		return self::$has_wpml;
	}
	
	public static function get_current_language() {
		
		if ( ! self::has_wpml() ) {
           return false;
		}
		
		$current_language_code = apply_filters( 'wpml_current_language', null );

        return $current_language_code;
	}

	public static function object_id( $id = 0, $type = '', $return_original = '', $lang_code = '' ) {
		if ( ! self::has_wpml() ) {
			return $id;
		}
		$lang_id = 0;
		if ( has_filter('wpml_object_id') ) {
			if ( $lang_code !== '' ) {
				$lang_id = apply_filters( 'wpml_object_id', $id, $type, $return_original, $lang_code );
			} else {
				$lang_id = apply_filters( 'wpml_object_id', $id, $type, $return_original );
			}
		}
		return $lang_id;
	}
}
